import pandas as pd
from sklearn.preprocessing import StandardScaler

from utils import cwd
with cwd('datasets'):
    df2 = pd.read_csv("creditcard.csv")
y = df2.Class.values
X = df2.drop(['Class'], axis=1).values

import numpy as np
from sklearn.decomposition import PCA
pca = PCA(n_components=7) # because the other credit dataset only has 7 features
X_pca = pca.fit_transform(X)
X_pca_scaled = StandardScaler().fit_transform(X_pca)

with cwd('datasets'):
    np.savetxt("credit1-PCA_features.csv", X_pca_scaled, delimiter=',')
    np.savetxt("credit1-labels.csv", y, delimiter=',')

with cwd('datasets'):
    df1 = pd.read_csv("card_transdata.csv")

    y = df1.fraud.values
    X = df1.drop(['fraud'], axis=1)

    X_scaled = StandardScaler().fit_transform(X.values)

    np.savetxt("credit2-features.csv", X_scaled, delimiter=',')
    np.savetxt("credit2-labels.csv", y, delimiter=',')
